<?php

include "session.php";
include "header.php"; // Incluir el menú
include "includes/functions.php";
include "config.php";

$id = $_GET["id"];
$slug = $_GET["slug"];
$ext = isset($_GET["ext"]) ? $_GET["ext"] : "mp4";
$logo_url = "assets/img/logo.png"; // URL del logo de tu sitio

$audio_tracks = []; // Inicializamos un array para las pistas de audio
$subtitles = []; // Inicializamos un array para las pistas de subtítulos

// Lógica para películas y series
if ($slug == "movie") {
    $video_url = $get_dns . "/movie/" . $username . "/" . $password . "/" . $id . "." . $ext;
    $mime_type = "video/mp4";  // Tipo para películas (MP4)
    
    // Obtener el nombre real de la película, las pistas de audio y subtítulos
    $movie_info = getXtreamData('get_vod_info', ['vod_id' => $id]);
    $content_name = $movie_info['info']['name'];
    $audio_tracks = $movie_info['info']['audio'] ?? []; // Asegúrate de que estas propiedades existan
} elseif ($slug == "series") {
    $video_url = $get_dns . "/series/" . $username . "/" . $password . "/" . $id . "." . $ext;
    $mime_type = "video/mp4";

    // Obtener el nombre de la serie y episodio, y las pistas de audio y subtítulos
    $series_info = getXtreamData('get_series_info', ['series_id' => $_GET['series_id']]);
    $content_name = $series_info['info']['name'];
    $audio_tracks = $series_info['info']['audio'] ?? [];
}

// Función para obtener datos desde Xtream Codes API
function getXtreamData($endpoint, $params = []) {
    global $get_dns, $username, $password;
    $url = $get_dns . "/player_api.php?username=" . $username . "&password=" . $password . "&action=" . $endpoint;
    if (!empty($params)) {
        $url .= '&' . http_build_query($params);
    }
    $response = file_get_contents($url);
    return json_decode($response, true);
}

?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Video.js Player - Cargar Subtítulos</title>
    <link href="https://vjs.zencdn.net/7.14.3/video-js.css" rel="stylesheet" />

    <style>
        html, body {
            margin: 0;
            padding: 0;
            width: 100%;
            height: 100%;
            background: #1c1c1c;
            font-family: 'Arial', sans-serif;
            display: flex;
            justify-content: center;
            align-items: center;
        }
        .video-player-container {
            width: 100%;
            height: 100%;
            position: relative;
        }
        .video-info {
            position: absolute;
            top: 10px;
            left: 20px;
            color: white;
            font-size: 24px;
            z-index: 2;
        }
        .video-player-logo {
            position: absolute;
            top: 10px;
            right: 20px;
            width: 100px;
            z-index: 2;
        }
        .back_button {
            position: absolute;
            top: 10px;
            left: 10px;
            background: rgba(0, 0, 0, 0.7);
            padding: 10px;
            cursor: pointer;
            border-radius: 50%;
            text-decoration: none;
            color: white;
            font-size: 16px;
            z-index: 5;
            transition: background 0.3s ease;
        }
        .back_button:hover {
            background: rgba(255, 0, 0, 0.8);
        }
        .subtitle-upload {
            position: absolute;
            bottom: 10px;
            left: 20px;
            z-index: 2;
        }
    </style>
</head>
<body>

    <div class="video-player-container">
        <a class="back_button" href="<?php echo $slug == 'movie' ? 'Movie_description.php?id=' . $id : 'seriesvideo.php?id=' . $_GET['series_id']; ?>">
            <i class="fa fa-arrow-left" aria-hidden="true"></i>
        </a>

        <div class="video-info">
            <h2><?php echo htmlspecialchars($content_name, ENT_QUOTES, 'UTF-8'); ?></h2> <!-- Nombre del contenido -->
        </div>

        <img src="<?php echo htmlspecialchars($logo_url, ENT_QUOTES, 'UTF-8'); ?>" class="video-player-logo" alt="Logo">

        <!-- Contenedor de Video.js -->
        <video id="player" class="video-js vjs-default-skin" controls preload="auto" width="100%" height="100%">
            <source src="<?php echo htmlspecialchars($video_url, ENT_QUOTES, 'UTF-8'); ?>" type="<?php echo htmlspecialchars($mime_type, ENT_QUOTES, 'UTF-8'); ?>">
            
            <!-- Agregar pistas de audio -->
            <?php foreach ($audio_tracks as $index => $track): ?>
                <track kind="audio" src="<?php echo htmlspecialchars($track['url'], ENT_QUOTES, 'UTF-8'); ?>" srclang="<?php echo htmlspecialchars($track['language'], ENT_QUOTES, 'UTF-8'); ?>" label="<?php echo htmlspecialchars($track['label'], ENT_QUOTES, 'UTF-8'); ?>" <?php echo $index === 0 ? 'default' : ''; ?>>
            <?php endforeach; ?>
        </video>

        <!-- Formulario para cargar subtítulos SRT -->
        <div class="subtitle-upload">
            <input type="file" id="subtitleFile" accept=".srt" />
            <button id="loadSubtitleBtn">Cargar Subtítulo</button>
        </div>
    </div>

    <script src="https://vjs.zencdn.net/7.14.3/video.min.js"></script>
    <script>
        // Inicializar el reproductor Video.js
        var player = videojs('player', {
            autoplay: true,
            muted: false,
            fluid: true,
            sources: [{
                src: "<?php echo htmlspecialchars($video_url, ENT_QUOTES, 'UTF-8'); ?>",
                type: "<?php echo htmlspecialchars($mime_type, ENT_QUOTES, 'UTF-8'); ?>"
            }]
        });

        // Manejar la carga del archivo SRT
        document.getElementById('loadSubtitleBtn').addEventListener('click', function() {
            var fileInput = document.getElementById('subtitleFile');
            var file = fileInput.files[0];
            if (file) {
                var url = URL.createObjectURL(file);
                player.addRemoteTextTrack({
                    kind: 'subtitles',
                    src: url,
                    srclang: 'es', // Cambia el lenguaje según sea necesario
                    label: 'Subtítulo cargado',
                    default: true
                }, false); // false para no activar automáticamente
            } else {
                alert('Por favor, selecciona un archivo SRT.');
            }
        });
    </script>

</body>
</html>
